globals [
  genes-to-phenotype                        ;; mapa genotyp a fenotyp
  bird-body-color  your-cage-color
  user-1-color  user-2-color  user-3-color
  this-site-id my-id                        ;; identifiktory pro udren spojen mezi uivatelem a msty pro ken
  parent-female  parent-male                ;; dva rodie potencilnch novch vajec

  frequency-allele-dominant-second-trait    ;; zaznamenvn etnosti jednotlivch alel 
  frequency-allele-dominant-first-trait
  frequency-allele-recessive-second-trait
  frequency-allele-recessive-first-trait
  frequency-allele-dominant-third-trait
  frequency-allele-recessive-third-trait
  frequency-allele-dominant-forth-trait
  frequency-allele-recessive-forth-trait

  second-trait-shape-1 second-trait-shape-2 second-trait-shape-3
  forth-shape-1 forth-shape-2 forth-shape-3

  bird-size
  current-funds                             ;; dostupn penze uivatele
  instruction                               ;; aktuln zobrazen instrukce
]



breed [birds bird]
breed [first-traits  first-trait]   ;; pta hebnky a dra kdla
breed [second-traits second-trait]  ;; pta kdla a dra dech
breed [third-traits  third-trait]   ;; hru u ptk i drak 
breed [forth-traits  forth-trait]   ;; ocas u ptk i drak
breed [cages cage]
breed [users user]




patches-own [site-id owner]
birds-own         [first-genes second-genes third-genes forth-genes fifth-genes sex-gene selected? owned-by]
first-traits-own  [first-genes second-genes third-genes forth-genes fifth-genes sex-gene selected? owned-by]
second-traits-own [first-genes second-genes third-genes forth-genes fifth-genes sex-gene selected? owned-by]
third-traits-own  [first-genes second-genes third-genes forth-genes fifth-genes sex-gene selected? owned-by]
forth-traits-own  [first-genes second-genes third-genes forth-genes fifth-genes sex-gene selected? owned-by]

users-own [user-id moving-a-bird?]


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; Procedury tlatka Piprav ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to make-users
  create-users 1 [set user-id 1 set hidden? true]
  create-users 1 [set user-id 2 set hidden? true]
  create-users 1 [set user-id 3 set hidden? true]
end


to setup
    clear-all
    make-users
    set instruction 0
    set this-site-id 0
    set parent-female nobody
    set parent-male nobody
    set current-funds 500
    set bird-size 0.8
    ask patches [set pcolor white]
    set your-cage-color (turquoise + 4)
    set user-1-color    (pink + 4)
    set user-2-color    (green + 4)
    set user-3-color    (brown + 4)
    set bird-body-color (gray + 2.5)
    set-scenario
    set-default-shape cages "cage"
    setup-my-cages
    setup-breeding-sites
    set my-id 4
    calculate-all-alleles
    visualize-genetics
    give-instructions
end



to set-scenario

   if scenar = "ptci" [

    set-default-shape birds "bird"
    set-default-shape first-traits "bird-cap"
    set-default-shape second-traits "bird-wing"
    set-default-shape third-traits "bird-breast"
    set-default-shape forth-traits "bird-tail"

    set-default-shape cages "cage"
    set genes-to-phenotype
      [
        ["AA" "set color gray"] ["Aa" "set color gray"] ["aA" "set color gray"] ["aa" "set color sky"]        ;; nastav barvu hebnku
        ["BB" "set color gray"] ["Bb" "set color gray"] ["bB" "set color gray"] ["bb" "set color red"]        ;; nastav barvu kdel
        ["CC" "set color gray"] ["Cc" "set color gray"] ["cC" "set color gray"] ["cc" "set color magenta"]    ;; nastav barvu hrudi
        ["DD" "set color gray"] ["Dd" "set color gray"] ["dD" "set color gray"] ["dd" "set color red" ]       ;; nastav barvu ocasu
      ]
      ]
   if scenar = "draci" [

    set-default-shape birds "dragon-body"          ;; tvar pro dra tlo
    set second-trait-shape-1 "dragon-breath-fire"          ;; ti varianty draho dechu
    set second-trait-shape-2 "dragon-breath-cloud"
    set second-trait-shape-3 "dragon-breath-ice"
    set-default-shape third-traits "dragon-chest"          ;; jeden tvar dra hrudi
    set forth-shape-1 "dragon-tail-spade"                  ;; ti varianty pro tvar ocasu
    set forth-shape-2 "dragon-tail-rope-spade"
    set forth-shape-3 "dragon-tail-rope"

    set genes-to-phenotype
      [
        ["AA"  "set color (yellow - 1)"] ["Aa"  "set color orange"] ["aA"  "set color orange"] ["aa"  "set color red"]                                                       ;; nastav barvu tla
        ["BB"  "set shape second-trait-shape-3"] ["Bb"  "set shape second-trait-shape-2"] ["bB"  "set shape second-trait-shape-2"] ["bb"  "set shape second-trait-shape-1"]  ;; nastav typ dechu
        ["CC"  "set color (gray - 2.5)"] ["Cc"  "set color (gray + 1)"] ["cC"  "set color (gray + 1)"] ["cc"  "set color white"]                                             ;; nastav barvu hrudi
        ["DD"  "set shape forth-shape-1"] ["Dd"  "set shape forth-shape-2"] ["dD"  "set shape forth-shape-2"] ["dd"  "set shape forth-shape-3" ]                             ;; nastav tvar ocasu
      ]
    ]
end



to give-instructions
    set instruction (instruction + 1)
    if instruction = 11 [set instruction 1]
    if instruction = 1 [
      output-print " "
      

      output-print "Nachzte se v programu genetickho"
      output-print "lechtn, jeho clem je doshnout"
      output-print "ozdobnho vzhledu ptactva." 
      output-print "Pro pokraovn stisknte"
      output-print "tlatko DAL INSTRUKCE."
    ]
    if instruction = 2 [
      output-print " "
      output-print " "

      output-print "V programu se nachz 4 hri"
      output-print "a vy jste jednm z nich"
      output-print "Pro pokraovn stisknte"
      output-print "tlatko DAL INSTRUKCE."
        ]
    if instruction = 3 [
      output-print " "
      output-print " "

      output-print "Jste hr slo 4 (modr)."
      output-print "Zante se temi vlastnmi" 
      output-print "ptky v esti klecch"  
      output-print "(ve spodn sti okna)."
      output-print "Pro pokraovn stisknte"
      output-print "tlatko DAL INSTRUKCE."
        ]
    if instruction = 4 [
      output-print " "
      output-print " "
      output-print "Uprosted okna vidte 6 barevn" 
      output-print "oznaench mst pro ken."
      output-print "Pro pokraovn stisknte"
      output-print "tlatko DAL INSTRUKCE."
        ]
     if instruction = 5 [
      output-print " "
      output-print " "

      output-print "Pokud umstte (pomoc myi)" 
      output-print "jednoho samce a jednu samici"
      output-print "do msta pro ken a stisknete"
      output-print "tlatko K͎IT UMSTN PTKY,"
      output-print "zskte tm vajka s novmi ptky."
      output-print "Pro pokraovn stisknte"
      output-print "tlatko DAL INSTRUKCE."
        ]
    if instruction = 6 [
      output-print " "
      output-print " "

      output-print "Vznikl vejce mete pesunout"
      output-print "zptky do klec. Dky tomu uvidte,"
      output-print "jak vypadaj vai nov ptci."
      output-print "Pro pokraovn stisknte"
      output-print "tlatko DAL INSTRUKCE."
        ]
    if instruction = 7 [
      output-print " "
      output-print ""
      output-print "Pokud chcete vypustit svho"
      output-print "ptka na svobodu, sta jej"
      output-print "pesunout pomoc myi na" 
      output-print "bl msto v okn modelu."
      output-print "Pro pokraovn stisknte"
      output-print "tlatko DAL INSTRUKCE."
        ]
     if instruction = 8 [
      output-print " "
      output-print " "
      output-print " "

      output-print "lechtn zante s 500$ a" 
      output-print (word "vam kolem je zskat alespo " odmena-za-vyslechteneho-ptaka "$.")
      output-print "Pro pokraovn stisknte"
      output-print "tlatko DAL INSTRUKCE."
            ]
     if instruction = 9 [
      output-print " "
      output-print " "

      output-print (word "Kad ken stoj " cena-krizeni "$.")
      output-print "Pokud chcete kit vae ptky"
      output-print "s dalm hrem, stisknte tlatko"
      output-print "ZADAT O POMOC PI LECHTN."
      output-print (word "To bude stt " cena-za-vypomoc "$ za kadho ptka.")
      output-print "Pro pokraovn stisknte"
      output-print "tlatko DAL INSTRUKCE."

    ]
   if instruction = 10 [
      output-print " "
      output-print " "
      output-print " "
      output-print "A bude pipraven zat lechtn,"
      output-print "stisknte tlatko START. Vechny"
      output-print "instrukce si mete opakovan"
      output-print "prohlet tlatkem DAL INSTRUKCE."
    ]
end


to setup-birds
       let this-cage owner
       sprout 1 [
         build-body-base
         set owned-by this-cage
         assign-all-genes
         build-body-parts
       ]
end


to setup-my-cages
   let these-cages nobody

   set these-cages patches with [pxcor = -4 and pycor <= 3 and pycor >= -2]
   ask these-cages
     [set pcolor user-1-color  set owner 1 sprout 1 [set breed cages set shape "cage"]]
   ask n-of 3 these-cages  [setup-birds]

   set these-cages patches with [pxcor <= 3 and pxcor >= -2 and pycor = 5]
   ask these-cages
     [set pcolor user-2-color set owner 2 sprout 1 [set breed cages set shape "cage"]]
   ask n-of 3 these-cages  [setup-birds]

   set these-cages patches with [pxcor = 5 and pycor >= -2 and pycor <= 3]
   ask these-cages
     [set pcolor user-3-color  set owner 3 sprout 1 [set breed cages set shape "cage"]]
   ask n-of 3 these-cages  [setup-birds]


   set these-cages patches with [pycor = -4 and pxcor >= -2 and pxcor <= 3]
   ask these-cages
     [set pcolor your-cage-color set owner 4 sprout 1 [set breed cages set shape "cage"]]
   ask n-of 3 these-cages  [setup-birds]

  ask patch 1 -3 [set plabel "Vae klece" set plabel-color black]
  ask patch 2 4 [set plabel "est mst pro ken" set plabel-color black]
  ask patch -4 4 [set plabel "Hr 1  " set plabel-color black]
  ask patch 5 4 [set plabel "Hr 3  " set plabel-color black]
  ask patch -3 5 [set plabel "Hr 2  " set plabel-color black]

end


to setup-breeding-sites
   ask patches with [pxcor >= -2 and pxcor <= -1 and pycor <= 3 and pycor >= 1]
     [set pcolor user-1-color   set site-id 1]
   ask patches with [pxcor >= 0 and pxcor <= 1 and pycor <= 3 and pycor >= 1]
     [set pcolor user-2-color  set site-id 2]
   ask patches with [pxcor >= 2 and pxcor <= 3 and pycor <= 3 and pycor >= 1]
     [set pcolor user-3-color  set site-id 3]

   ask patches with [pxcor >= -2 and pxcor <= -1 and pycor <= 0 and pycor >= -2]
     [set pcolor (your-cage-color - .2)  set site-id 4]
   ask patches with [pxcor >= 0 and pxcor <= 1 and pycor <= 0 and pycor >= -2]
     [set pcolor (your-cage-color + .2) set site-id 5]
   ask patches with [pxcor >= 2 and pxcor <= 3 and pycor <= 0 and pycor >= -2]
     [set pcolor (your-cage-color - .2) set site-id 6]
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;  Procedury tlatka Start ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to go
  listen-move-birds
  listen-free-birds
  hatch-eggs
  visualize-genetics
  calculate-all-alleles
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;  Procedury pro kontrolu dosaen cle ;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



to check-for-goal
  let winning-text ""
  let potential-winners birds with [my-id = owned-by and shape != "egg" and is-goal-bird?]
  let winner nobody

  if any? potential-winners    [
    set winner one-of potential-winners

    set current-funds (current-funds + odmena-za-vyslechteneho-ptaka)
    set winning-text "spn jste vylechtili poadovanho ptka a zskali jste od sbratele zaslouenou odmnu! "
    if current-funds > 500 [set winning-text (word winning-text " Nakonec jste vydlali (" current-funds "$), co je vce penz, n s kolika jste zanali!")]
    if current-funds < 500 [set winning-text (word winning-text " Nakonec jste vydlali (" current-funds "$), co je mn penz, n s kolika jste zanali!")]
    if current-funds <  0 [set winning-text (word winning-text " Nakonec jste ale skonili zadlueni.")]

    ask winner [ask out-link-neighbors [die] die]
    user-message winning-text
  ]
    ;; [set winning-text "Jet jste nevylechtili clovho ptka. Vae stvajc ptky od vs nikdo nechce koupit."]

end



to visualize-genetics
  ask birds [
  set label-color black
    ifelse ukazat-geny?
       [
       set label (word first-genes " " second-genes " " forth-genes " "
          third-genes " " sex-gene) ]         ;; zobraz genovou reprezentaci u vech ptk
       [set label owned-by]                   ;; zobraz id hre, kter vlastn tohoto ptka
  ]
end


to contribute-birds
  ;; vybere po jednom ptku od kadho dalho hre a vlo je do mst pro ken
  let open-sites patches with [not any? birds-here and site-id >= 1 and site-id <= 3]
  let target-site nobody
  let this-user-id 0
  let distance-to-target 0

  ask users [
     set current-funds (current-funds - cena-za-vypomoc)
     set this-user-id user-id
     set target-site one-of open-sites with [this-user-id = site-id and not any? users-here]
     ask one-of birds with [this-user-id = owned-by]
        [setxy ([pxcor] of target-site)  ([pycor] of target-site)]
     set moving-a-bird? true
  ]
end


to return-birds
  ;; vrt ostatnm hrm ptky zpt do jejich klec
   let target-cage nobody
   let this-owner 0
   ask birds with [owned-by != my-id and owned-by = site-id] [
     set this-owner owned-by
     set target-cage one-of patches with [owner = this-owner and not any? birds-here]
     setxy ([pxcor] of target-cage)  ([pycor] of target-cage)
   ]
end


to share-others-birds  ;; dost o vpomoc u ostatnch hr sestv ze dvou krok
 return-birds
 contribute-birds
end


to calculate-all-alleles
  ;; zkontroluje, zda jsou v poten populaci zastoupeny vechny alely
  ;; v opanm ppad by nebylo mon vylechtit poadovanho ptka
  set frequency-allele-dominant-first-trait (count birds with [(item 0 first-genes) = "A"]) + (count birds with [(item 0 first-genes) = "A"])
  set frequency-allele-recessive-first-trait (count birds with [(item 1 first-genes) = "a"]) + (count birds with [(item 1 first-genes) = "a"])
  set frequency-allele-dominant-second-trait (count birds with [(item 0 second-genes) = "B"]) + (count birds with [(item 0 second-genes) = "B"])
  set frequency-allele-recessive-second-trait (count birds with [(item 1 second-genes) = "b"]) + (count birds with [(item 1 second-genes) = "B"])
  set frequency-allele-dominant-third-trait (count birds with [(item 0 third-genes) = "C"]) + (count birds with [(item 0 third-genes) = "C"])
  set frequency-allele-recessive-third-trait (count birds with [(item 1 third-genes) = "c"]) + (count birds with [(item 1 third-genes) = "c"])
  set frequency-allele-dominant-forth-trait (count birds with [(item 0 forth-genes) = "D"]) + (count birds with [(item 0 forth-genes) = "D"])
  set frequency-allele-recessive-forth-trait (count birds with [(item 1 forth-genes) = "d"]) + (count birds with [(item 1 forth-genes) = "d"])
  ifelse (both-second-trait-alleles-exist? and both-first-trait-alleles-exist? and both-forth-alleles-exist? and both-third-trait-alleles-exist? and both-sexes-exist?)
   []
   [user-message (word "Aktuln kombinace ptk v klecch vech hr nevykazuje dostatenou genetickou"
    "rozmanitost, kter by umonila vylechtit poadovanho ptka."
    "  Stisknte tlatko PIPRAV pro nov sputn programu.")
    ]

end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;  Procedury ken ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to breed-birds
  ask turtles with [shape = "egg"] [die]
  ask birds with [is-female? and site-id != 0 and not selected? ] [
      set this-site-id site-id
      set parent-female self
     if (has-one-mate?) [ make-eggs ]
   ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;  Procedury vajec ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to hatch-eggs
  ask birds with [shape = "egg" and in-cage? and not selected?] [
    build-body-base
    build-body-parts
  ]
end

to make-eggs
   set current-funds (current-funds - cena-krizeni)
   let open-patches patches with [site-id = this-site-id and not any? birds-here]
   ask open-patches [sprout 1 [make-an-egg]]
end


to make-an-egg
  set breed birds
  assign-genetics-from-parents
  set shape "egg"
  set color blue
  set selected? false
  set size 0.5
  set owned-by my-id
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;  Procedury pro skldn tla ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to build-body-base
  set breed birds
  if scenar = "ptci" [ set shape "bird" ]
  if scenar = "draci" [set shape "dragon-body"]
  set size bird-size
  set selected? false
  set color bird-body-color
end


to assign-all-genes
  set first-genes (word random-first-genes random-first-genes)
  set second-genes (word random-second-genes random-second-genes)
  set third-genes (word random-third-genes random-third-genes)
  set forth-genes (word random-forth-genes random-forth-genes)
  set sex-gene random-sex-genes
end


to build-body-parts
  let body-label label
  set label "" ;; doasn odstran popisek
  set size bird-size
 if scenar = "ptci"
  [
    if is-male? [
      hatch 1 [run lookup-phenotype-for-gene first-genes set breed first-traits   create-link-from myself  [tie] ]
    ]
   hatch 1 [run lookup-phenotype-for-gene second-genes set breed second-traits  create-link-from myself  [tie] ]
   hatch 1 [run lookup-phenotype-for-gene forth-genes  set breed forth-traits   create-link-from myself  [tie] ]
   hatch 1 [run lookup-phenotype-for-gene third-genes  set breed third-traits   create-link-from myself  [tie] ]
  ]

 if scenar = "draci"
  [
    run lookup-phenotype-for-gene first-genes

    hatch 1 [set breed second-traits run lookup-phenotype-for-gene second-genes   create-link-from myself  [tie] ]

    ifelse is-male?
        [hatch 1 [set breed first-traits set shape "dragon-wing-male" create-link-from myself  [tie]  ]]
        [hatch 1 [set breed first-traits set shape "dragon-wing-female" create-link-from myself  [tie]  ]]

    hatch 1 [set breed second-traits run lookup-phenotype-for-gene second-genes   create-link-from myself  [tie] ]
    hatch 1 [set breed third-traits run lookup-phenotype-for-gene third-genes    create-link-from myself  [tie] ]
    hatch 1 [set breed forth-traits run lookup-phenotype-for-gene forth-genes   create-link-from myself  [tie] ]
 ]
  set label body-label
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;  Procedury pemsovn ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




to listen-move-birds
 let snap-xcor mouse-xcor
 let snap-ycor mouse-ycor
 let birds-selected nobody
 let birds-available nobody


 if mouse-inside? [
    set birds-selected (birds with [selected?])
    ask birds-selected  [setxy snap-xcor snap-ycor]   ;; pesune vybranho ptka do oblasti pod kurzorem myi 
    if (mouse-down? and not any? birds-selected) [    ;; pokud je stisknuto tlatko myi a dosud nebylo nic nabrno, pak nabere ptka

       set birds-available birds with [pxcor = round snap-xcor and pycor = round snap-ycor and is-my-bird?]
       if any? birds-available [
        ask n-of 1 birds-available [ set selected? true ]
       ]
   ]

   if (count birds with [pxcor = round snap-xcor and pycor = round snap-ycor] = 1) [  ;; na tomto polku je pouze jeden ptk (ten, kter sem byl pesunut)
       if (not mouse-down?) [        ;; ptk je pesunut na toto polko, pokud je vlastnn uivatelem nebo pokud je nabdnut ostatnmi hri
           ask (birds-selected with [my-id = owner or owner = 0]) [set selected? false setxy pxcor pycor ]
       ]
   ]
  ]

end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;  Procedury odstrann ptk a vajec  ;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to listen-free-birds
   ask birds with [owner = 0 and site-id = 0 and not selected?] [remove-bird]
end

to remove-bird
  ask other turtles-here [die]
  die
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;; Pomocn procedury  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to assign-genetics-from-parents
  set first-genes inherited-first-genes
  set third-genes inherited-third-genes
  set second-genes inherited-second-genes
  set forth-genes inherited-forth-genes
  set sex-gene inherited-sex-genes
end

to-report inherited-first-genes
  let mother-loci (random 2)
  let father-loci (random 2)
  let mother-allele ""
  let father-allele ""
  ask parent-female [set mother-allele (item mother-loci first-genes)]
  ask parent-male [set father-allele  (item father-loci first-genes)]
  report (word mother-allele father-allele)
end

to-report inherited-third-genes
  let mother-loci (random 2)
  let father-loci (random 2)
  let mother-allele ""
  let father-allele ""
  ask parent-female [set mother-allele (item mother-loci third-genes)]
  ask parent-male [set father-allele  (item father-loci third-genes)]
  report (word mother-allele father-allele)
end

to-report inherited-second-genes
  let mother-loci (random 2)
  let father-loci (random 2)
  let mother-allele ""
  let father-allele ""
  ask parent-female [set mother-allele (item mother-loci second-genes)]
  ask parent-male [set father-allele  (item father-loci second-genes)]
  report (word mother-allele father-allele)
end


to-report inherited-forth-genes
  let mother-loci (random 2)
  let father-loci (random 2)
  let mother-allele ""
  let father-allele ""
  ask parent-female [set mother-allele (item mother-loci forth-genes)]
  ask parent-male [set father-allele  (item father-loci forth-genes)]
  report (word mother-allele father-allele)
end

to-report inherited-sex-genes
  let mother-loci (random 2)
  let father-loci (random 2)
  let mother-allele ""
  let father-allele ""
  ask parent-female [set mother-allele (item mother-loci sex-gene)]
  ask parent-male [set father-allele  (item father-loci sex-gene)]
  report (word mother-allele father-allele)
end


to-report random-first-genes
   ifelse random 2 = 0
     [report "A"]
     [report "a"]
end

to-report random-second-genes
   ifelse random 2 = 0
     [report "B"]
     [report "b"]
end

to-report random-third-genes
   ifelse random 2 = 0
     [report "C"]
     [report "c"]
end

to-report random-forth-genes
   ifelse random 2 = 0
     [report "D"]
     [report "d"]
end


to-report random-sex-genes
  ifelse random 2 = 0
    [report "WZ"]
    [report "ZZ"]
end

to-report is-male?
  ifelse sex-gene = "ZZ"
    [report true]
    [report false]
end

to-report is-female?
  ifelse sex-gene = "WZ"
    [report true]
    [report false]
end


to-report has-one-mate?
     let birds-at-site-id birds-on patches with [site-id = this-site-id]
     let report? false
     let eligible-males birds-at-site-id with [is-male?]
     if (count eligible-males = 1)  [
       set report? true
       set parent-male one-of eligible-males
     ]
     report report?
end

to-report in-cage?
  ifelse (owner != 0)
      [report true]
      [report false]
end

to-report both-sexes-exist?
  ifelse (any? birds with [is-male?] and any? birds with [is-female?])
    [report true]
    [report false]
end

to-report both-second-trait-alleles-exist?
  ifelse (frequency-allele-dominant-second-trait > 0 and frequency-allele-recessive-second-trait  > 0)
    [report true]
    [report false]
end

to-report both-third-trait-alleles-exist?
  ifelse (frequency-allele-dominant-third-trait > 0 and frequency-allele-recessive-third-trait  > 0)
    [report true]
    [report false]
end

to-report both-forth-alleles-exist?
  ifelse (frequency-allele-dominant-forth-trait > 0 and frequency-allele-recessive-forth-trait  > 0)
    [report true]
    [report false]
end

to-report both-first-trait-alleles-exist?
  ifelse (frequency-allele-dominant-first-trait > 0 and frequency-allele-recessive-first-trait  > 0)
    [report true]
    [report false]
end

to-report is-my-bird?
  ifelse my-id = owned-by [report true] [report false]
end


to-report is-goal-bird?
  ifelse ( first-genes = "aa" and second-genes = "bb" and third-genes = "cc" and forth-genes = "dd" )
    [report true]
    [report false]
end



to-report lookup-phenotype-for-gene [x]
  let item-counter 0
  let target-phenotype 0
  let target-item 0
  repeat length genes-to-phenotype [
    if (item 0 (item item-counter genes-to-phenotype)) = x
      [set target-phenotype (item 1 (item item-counter genes-to-phenotype))]
    set item-counter (item-counter + 1)
  ]
  set item-counter 0
  report target-phenotype
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; Copyright 2007 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Novak, M. and Wilensky, U. (2007). NetLogo Bird Breeder model.
; http://ccl.northwestern.edu/netlogo/models/BirdBreeder.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2007 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/BirdBreeder
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
299
10
809
541
-1
-1
50.0
1
10
1
1
1
0
1
1
1
-4
5
-4
5
0
0
1
ticks

CC-WINDOW
5
555
818
650
Command Center
0

BUTTON
9
10
80
43
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
82
10
154
43
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
5
311
250
344
Kit umstn ptky
breed-birds
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SWITCH
6
190
150
223
ukazat-geny?
ukazat-geny?
1
1
-1000

BUTTON
6
383
250
416
Odstranit vechna vejce z msta ken
ask birds with [shape = \"egg\"] [die]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
156
189
291
222
cena-krizeni
cena-krizeni
0
20
10
5
1
NIL
HORIZONTAL

SLIDER
4
274
243
307
odmena-za-vyslechteneho-ptaka
odmena-za-vyslechteneho-ptaka
200
1000
1000
100
1
NIL
HORIZONTAL

BUTTON
6
347
250
380
Zadat o vpomoc pi lechtn
share-others-birds
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
6
231
191
264
cena-za-vypomoc
cena-za-vypomoc
0
20
10
5
1
NIL
HORIZONTAL

MONITOR
209
224
271
269
finance $
current-funds\n
3
1
11

OUTPUT
5
81
295
186
12

TEXTBOX
13
424
283
466
Cl ptaho scne: vylechtit 3 ptky s modrm hebnkem, fialovou hrud, ervenmi kdly a ervenmi ocasnmi pery.
11
0.0
0

BUTTON
7
47
154
80
Dal instrukce
give-instructions
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

CHOOSER
167
10
279
55
scenar
scenar
"ptci" "draci"
0

TEXTBOX
13
469
269
516
Cl draho scne: vylechtit 3 draky s ohnivm dechem, blou hrud, ervenm tlem a dlouhm tenkm ocasem.
11
0.0
0

BUTTON
101
501
288
534
Prodat vylechtnho ptka
check-for-goal
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

@#$#@#$#@
CO TO JE?
---------

Tento model je zamen na lechtn ptk (nebo drak). Uivatel je v roli chovatele, kter se sna pomoc clenho ken doshnout specifick podoby ptk nebo drak. 

JAK TO FUNGUJE?
---------------

Ve scni ptci ovlivuje uivatel kenm pt genetickch znak, tkajcch se vzhledu: barvu hebnku, kdel, hrudi, ocasu a pohlav ptk.

V ptam scni jsou tyto znaky reprezentovny geny, kter sestvaj ze dvou alel (konkrtnch projev genu - A/a, B/b, C/c, D/d, W/Z). Velk psmena zastupuj dominantn geny a mal psmena zastupuj recesivn geny. Existuj tedy ti rzn kombinace AA, Aa, aA, kter se projev jako znak A (napklad ed hebnek) a pouze jedna kombinace aa, kter se projev jako znak a (napklad erven hebnek). Pohlav ptk je dno genetickou kombinac ZZ (samec) nebo WZ (samice). Jeden z vizulnch znak (hebnek) je dn prv pohlavm. Samci (ZZ) maj hebnek, zatmco samice (WZ) nikoliv (pesto nesou ve svch genech informaci o barv hebnku, kter by se projevila, kdyby byly opanho pohlav).

Ve scni draci ovlivuje uivatel kenm pt genetickch znak, tkajcch se vzhledu: barvu tla, typ dechu, barvu hrudi, tvar ocasu a pohlav drak.

V dram scni jsou tyto znaky reprezentovny geny, kter sestvaj kad ze dvou alel (konkrtnch projev genu - A/a, B/b, C/c, D/d, W/Z). Samce a samice lze rozliit podle tvaru kdel. Velk psmena v tomto scni nezastupuj dominantn geny. Geny v tomto scni funguj na principu spolu-dominance, kde dochz vdy k projevm obou alel, m vznikaj smen nebo zdvojen projevy gen. Pokud napklad A reprezentuje lut zbarven a reprezentuje erven zbarven, pak bude projevem kombinace AA lut barva, Aa/aA oranov barva, aa erven barva.

Zde je k dispozici pehledn mapa genotyp a jejich projev (fenotyp) pro oba scne:

Pta scn: barva hebnku - (AA, Aa, aA) ed nebo (aa) modr; barva kdel - (BB, Bb, bB) ed nebo (bb) erven; barva hrudi - (CC, Cc, cC) ed nebo (cc) fialov; barva ocasu - (DD, Dd, dD) ed nebo (dd) erven

Dra scn: barva tla: (AA) lut nebo (Aa, aA) oranov nebo (aa) erven; typ dechu - (BB) mraziv dech nebo (Bb, bB) parn dech nebo (bb) ohniv dech; barva hrudi - (CC) ern nebo (Cc, cC) ed nebo (cc) bl; tvar ocasu - (DD) povit nebo (Dd, dD) dlouh+povit nebo (dd) dlouh 

JAK MODEL OVLDAT
-----------------

V programu lechtn jsou tyi hri a vy jste jednm z nich. Ostatn ti hri jsou ovldni potaem. Pi lechtn zastvaj pasivn roli, nebo jejich ptky je mon kit s vaimi vlastnmi. Zante se temi ptky a esti klecemi (ve spodn sti okna). Uprosted okna je est (barevn oznaench) mst urench pro ken. Pokud (pomoc myi) pesunete samce a samici na tato msta pro ken a stisknete tlatko K͎IT UMSTN PTKY, zskte tm vejce s novmi jedinci. Po pesunut vajec do vaich klec uvidte vzhled novch ptk. Pro vyputn ptka na svobodu jej sta z klece pemstit do blho prostoru v okn modelu. Vypustit lze pouze vae vlastn ptky.

lechtn zante s 500$ a vam kolem je vydlat odmnu za vylechtn specifick podoby ptk (odmnu lze nastavit pomoc posuvnku ODMENA-ZA-VYSLECHTENEHO-PTAKA). Kad ken vs pitom stoj cenu urenou posuvnkem CENA-ZA-KRIZENI. Pokud chcete sv ptky kit s ptky jinho hre, stisknte tlatko ZADAT O VPOMOC PI LECHTN. Bude vs to stt cenu urenou posuvnkem CENA-ZA-VYPOMOC za kadho ptka.

Vchoz nastaven (pepna): - SCENAR: umouje pepnat mezi programem pro lechtn ptk a drak.

Tlatka: - PIPRAV: piprav okno modelu pro vybran scn; - START: zahj program lechtn; - DAL INSTRUKCE: zobrazuje adu instrukc, kter popisuj uivateli, jak m ovldat rozhrann modelu; - ZADAT O VPOMOC PI LECHTN: po stisknut bude od kadho dalho hre umstn jeden ptk do hornch mst pro ken; - K͎IT UMSTN PTKY: po stisknut se ve vech mstech pro ken, ve kterch je umstn alespo jeden samec a jedna samice, objev vejce, ktermi je vyplnn zbvajc prostor (maximln tyi msta). Pokud vlote do jednoho msta vce ne jednoho samce i samici, pak dojde ke ken pouze u jednoho umstnho pru. - ODSTRANIT VECHNA VEJCE Z MSTA K͎EN: odstran vechna vejce, kter se aktuln nachz v mstech pro ken. - PRODAT VYLECHTNHO PTKA: tmto tlatkem se mete pokusit prodat ptka, kterho jste se snaili vylechtit. Pokud jej mte, budete informovni o zskan odmn. V tomto ppad bude ptk odebrn z va klece a zskte odmnu urenou posuvnkem ODMENA-ZA-VYSLECHTENEHO-PTAKA.

Posuvnky: - CENA-KRIZENI: nklady na zken jednoho pru ptk; - CENA-ZA-VYPOMOC: nklady, kter zaplatte po stisknut tlatka ZADAT O VPOMOC PI LECHTN; - ODMENA-ZA-VYSLECHTENEHO-PTAKA: odmna za prodn clovho vylechtnho ptka.

Pepna: - UKAZAT-GENY?: zobraz kombinaci gen u kadho ptka i vejce.

Ukazatele: - Finance $: aktuln mnostv penz, kter mte k dispozici. 

VIMNTE SI
-----------

Pestoe pi kadm ken ptaho pru vzniknou tyi nov vejce, nemus tato vejce (z hlediska genov struktury) nutn odret pravdpodobnostn rozloen odpovdajc klasick Mendelinsk reprezentaci kombinace gen. Tyto ideln pravdpodobnosti toti uruj, jakch vsledk bychom doshli pi nekonenm potu ken. 

VYZKOUEJTE SI
--------------

Zkuste si, zda dokete vylechtit poadovanho ptka s vyuitm minimlnho potu generac.

Sepite si svj program pro ken, kterm chcete doshnout clov podoby ptka. Nakreslete si rodokmen, kter povede pes jednotliv generace k poadovanm charakteristikm. 

ROZEN MODELU
----------------

Model ukazuje dva odlin scne - ptky a draky. Mete do modelu pidat dal scne, jako je napklad lechtn virtulnch ps, koek, kukuice atd.

Tento model by bylo mon rozit na HubNet verzi, kde by si tyi skuten hri mohli aktivn konkurovat pi zvodech ve lechtn. 

SOUVISEJC MODELY
------------------

Plant Hybridization (ken rostlin).

PODKOVN A ODKAZY
-------------------
Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Novak, M. and Wilensky, U. (2007).  NetLogo Bird Breeder model.  http://ccl.northwestern.edu/netlogo/models/BirdBreeder.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace:  Copyright 2007 Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/BirdBreeder for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bird
false
0
Polygon -7500403 true true 0 120 45 90 75 90 105 120 150 120 240 135 285 120 285 135 300 150 240 150 195 165 255 195 210 195 150 210 90 195 60 180 45 135
Circle -16777216 true false 38 98 14

bird side
false
0
Polygon -7500403 true true 0 120 45 90 75 90 105 120 150 120 240 135 285 120 285 135 300 150 240 150 195 165 255 195 210 195 150 210 90 195 60 180 45 135
Circle -16777216 true false 38 98 14

bird-all
false
0
Polygon -2674135 true false 45 90 15 60 45 75 30 45 60 75 60 30 75 75 90 45 90 75 120 60 90 90 135 90 90 105
Polygon -7500403 true true 0 120 45 90 75 90 105 120 150 120 240 135 285 120 285 135 300 150 240 150 195 165 255 195 210 195 150 210 90 195 60 180 45 135
Circle -16777216 true false 38 98 14
Polygon -2674135 true false 255 195 195 165 165 150 120 150 150 180 210 195
Polygon -2674135 true false 60 180 54 163 105 180 150 210 90 195
Polygon -2674135 true false 240 150 300 150 285 135 285 120 240 135 255 135

bird-breast
false
1
Polygon -2674135 true true 60 180 54 163 105 180 150 210 90 195

bird-cap
false
1
Polygon -2674135 true true 45 90 15 60 45 75 30 45 60 75 60 30 75 75 90 45 90 75 120 60 90 90 135 90 90 105

bird-cap-extreme
false
1
Polygon -2674135 true true 43 88 30 73 43 73 44 58 58 73 59 36 58 43 73 58 93 44 88 58 134 64 103 73 124 78 138 81 213 100 149 94 103 88 212 115 110 102 105 105 75 90

bird-tail
false
1
Polygon -2674135 true true 240 150 300 150 285 135 285 120 240 135 255 135

bird-tail-delta
false
1
Polygon -2674135 true true 240 150 300 150 285 135 285 120 240 135 255 135

bird-tail-frayed
false
1
Polygon -2674135 true true 240 135 255 75 258 112 283 80 270 120 293 107 275 135 297 142 270 150 300 165 270 165 290 207 236 151 255 135

bird-tail-split
false
1
Polygon -2674135 true true 240 135 300 60 270 135 300 210 240 150 255 135

bird-tails
false
1
Polygon -2674135 true true 240 150 300 150 285 135 285 120 240 135 255 135
Polygon -2674135 true true 240 135 285 90 270 135 300 195 240 150 255 135
Polygon -1184463 true false 240 135 255 75 258 112 283 80 270 120 293 107 275 135 297 142 270 150 300 165 270 165 290 207 236 151 255 135

bird-wing
false
1
Polygon -2674135 true true 255 195 195 165 165 150 120 150 150 180 210 195

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

cage
false
0
Rectangle -16777216 false false 0 0 300 300

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

dragon-all
false
0
Polygon -10899396 true false 105 150 75 135 60 165 45 150 45 165 30 150 15 165 0 135 30 90 45 75 75 75 105 105 120 150
Polygon -955883 true false 45 30 1 50 15 60 45 60 75 75 90 60 105 120 90 150 60 180 45 240 90 285 150 285 210 255 225 225 255 210 270 210 255 195 225 195 180 210 165 225 150 225 165 165 150 105 120 45 90 30 105 0 75 15 75 30 60 30 60 15 30 0
Circle -1 true false 30 15 30
Circle -16777216 true false 33 22 14
Circle -1 true false 45 15 30
Circle -16777216 true false 53 22 14
Line -1 false 49 240 124 240
Line -1 false 60 180 120 180
Line -1 false 75 270 120 270
Line -1 false 90 150 120 150
Line -1 false 105 120 120 120
Line -1 false 52 210 106 210
Polygon -10899396 true false 150 135 180 105 210 120 210 90 240 120 255 90 270 120 300 90 270 30 240 15 195 15 150 45 135 90
Polygon -10899396 true false 207 297 237 252 237 282 267 297
Polygon -10899396 true false 236 278 263 264 283 240 289 218 281 206 266 209 255 195 281 193 297 207 298 228 290 248 273 268 239 289
Polygon -10899396 true false 260 202 233 181 293 196 248 241

dragon-body
false
2
Polygon -955883 true true 45 30 1 50 15 60 45 60 75 75 90 60 105 120 90 150 60 180 45 240 90 285 150 285 210 255 225 225 255 210 270 210 255 195 225 195 180 210 165 225 150 225 165 165 150 105 120 45 90 30 105 0 75 15 75 30 60 30 60 15 30 0
Circle -1 true false 25 10 40
Circle -16777216 true false 30 17 24
Circle -1 true false 45 10 40
Circle -16777216 true false 56 17 24
Line -955883 true -60 255 -45 270
Line -955883 true -60 255 -45 270

dragon-breath-cloud
false
0
Circle -1 true false 28 58 32
Circle -1 true false -2 103 32
Circle -13345367 false false 28 58 32
Circle -13345367 false false -2 103 32
Circle -1 true false 15 75 58
Circle -13345367 false false 15 75 58
Circle -1 true false 0 120 58
Circle -13345367 false false 0 120 58
Polygon -1 true false 30 75 15 150 45 150 45 120 45 75

dragon-breath-fire
false
0
Polygon -2674135 true false 45 60 30 60 0 135 15 120 0 180 15 150 15 225 30 180 45 210 30 150 75 195 45 135 75 150 45 105
Polygon -1184463 true false 45 60 15 120 30 150 30 105 45 135 37 96

dragon-breath-ice
false
0
Polygon -11221820 true false 0 120 15 165 30 135 30 195 45 135 60 180 60 135 75 165 75 105 60 75 60 60 45 60 30 75 15 90
Polygon -13345367 false false 45 60 15 90 0 120 15 165 30 135 30 195 45 135 60 180 60 135 75 165 75 105 60 75 60 60

dragon-chest
false
13
Polygon -2064490 true true 105 90 120 120 120 150 120 180 105 210 120 240 120 270 150 285 90 285 45 240 60 180 90 150 105 120 96 91
Line -16777216 false 49 240 118 240
Line -16777216 false 60 180 120 180
Line -16777216 false 75 270 120 270
Line -16777216 false 90 150 120 150
Line -16777216 false 105 120 120 120
Line -16777216 false 52 210 106 210

dragon-eyes
false
0
Circle -1 true false 30 15 30
Circle -16777216 true false 33 22 14
Circle -1 true false 45 15 30
Circle -16777216 true false 53 22 14

dragon-tail-rope
false
0
Polygon -16777216 true false 240 285 263 264 283 240 289 218 281 206 266 209 255 195 281 193 297 207 298 228 290 248 273 268 239 289

dragon-tail-rope-spade
false
0
Polygon -16777216 true false 207 297 237 252 237 282 267 297
Polygon -16777216 true false 236 278 263 264 283 240 289 218 281 206 266 209 255 195 281 193 297 207 298 228 290 248 273 268 239 289

dragon-tail-spade
false
0
Polygon -16777216 true false 260 202 233 181 293 196 248 241

dragon-tails
false
0
Polygon -10899396 true false 207 297 237 252 237 282 267 297
Polygon -10899396 true false 236 278 263 264 283 240 289 218 281 206 266 209 255 195 281 193 297 207 298 228 290 248 273 268 239 289
Polygon -10899396 true false 260 202 233 181 293 196 248 241

dragon-wing-female
false
8
Polygon -10899396 true false 152 146 176 95 202 70 239 58 276 68 296 99 300 159 294 197 270 156 241 140 205 136 168 151 153 170
Polygon -10899396 true false 118 146 94 95 68 70 31 58 -6 68 -26 99 -30 159 -24 197 0 156 29 140 65 136 102 151 117 170

dragon-wing-male
false
9
Polygon -10899396 true false 107 169 119 147 96 112 87 72 95 36 60 60 15 75 -15 60 -25 25 -36 86 -38 152 -33 209 -9 243 -22 196 -14 167 3 147 24 153 36 174 52 154 66 154 74 172 74 182 93 163 103 164
Polygon -10899396 true false 148 169 136 147 159 112 168 72 160 36 195 60 240 75 270 60 280 25 291 86 293 152 288 209 264 243 277 196 269 167 252 147 231 153 219 174 203 154 189 154 181 172 181 182 162 163 152 164

egg
false
0
Circle -7500403 true true 96 76 108
Circle -7500403 true true 72 104 156
Polygon -7500403 true true 221 149 195 101 106 99 80 148

empty
true
0

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

rooster-all
false
0
Polygon -955883 true false 45 30 15 45 45 60 60 165 135 240 150 240 180 210 270 180 240 135 135 120 105 75 90 45 60 30
Circle -16777216 true false 38 38 14
Polygon -2674135 true false 240 180 195 165 165 150 120 150 150 180 210 195
Polygon -2674135 true false 45 30 30 0 45 15 45 0 60 15 75 0 75 15 90 0 73 39
Polygon -2674135 true false 31 50 25 75 33 99 49 78 46 61
Polygon -2674135 true false 225 135 240 75 270 30 300 30 285 45 300 45 285 60 285 90 300 75 285 105 300 105 285 120 300 135 285 150 285 165 270 165 270 180 255 180 240 150
Line -1184463 false 135 240 120 285
Line -1184463 false 150 240 145 270
Line -1184463 false 120 285 75 285
Line -1184463 false 120 285 105 300
Line -1184463 false 120 285 150 300
Line -1184463 false 146 269 171 277
Line -1184463 false 145 270 130 270

site
false
0
Rectangle -7500403 true true 0 0 300 300

site-ne
false
0
Rectangle -7500403 true true 0 0 300 300
Line -16777216 false 300 300 300 0
Line -16777216 false 0 0 300 0

site-new
false
0
Rectangle -7500403 true true 0 0 300 300

site-nw
false
0
Rectangle -7500403 true true 0 0 300 300
Line -16777216 false 0 300 0 0
Line -16777216 false 0 0 300 0

site-se
false
0
Rectangle -7500403 true true 0 0 300 300
Line -16777216 false 300 300 300 0
Line -16777216 false -15 300 285 300

site-sw
false
0
Rectangle -7500403 true true 0 0 300 300
Line -16777216 false 0 300 0 0
Line -16777216 false 0 300 300 300

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
